varying vec2 f_texcoord;
varying float f_alpha;
uniform sampler2D texture;

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
#endif

void main(void)
{
	vec4 colorResult = texture2D(texture, f_texcoord) * vec4(currentLight.ambient+currentLight.diffuse*0.25, f_alpha);
	if(colorResult.a < 0.05)
		discard;

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR, f_fogFactor);
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR_GROUND, f_fogFactorGround);
#endif

	gl_FragColor = colorResult;
}
